/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

//nothing to see here in the code, just playing with some simple rendering
//wanted to make more types but it wouldn't compile :(

//V2 changed the picture postcards to chits for no apparent reason
//V3 corrected the spelling of bawbles-lol important stuff!

#define TAO 6.2831853
#define size iResolution
#define time iGlobalTime

const int steps=32;
const float HitDistance=0.001;
float spec=0.5,specExp=32.0;
vec3 trap=vec3(0.0);
bool bColoring=false;
mat2 RMat2(float a){return mat2(cos(a),sin(a),-sin(a),cos(a));}
mat2 rmx1,rmx2;
float typ=0.0;

float DE(vec3 z)
{//octo from fragmentarium with ideas from Knighty
	float dS;
	if(z.x+z.z<0.0)z.xz=-z.zx;if(z.x<z.z)z.xz=z.zx;if(z.x<z.y)z.xy=z.yx;z*=2.0;z.x-=1.0;
	if(z.x+z.z<0.0)z.xz=-z.zx;if(z.x<z.z)z.xz=z.zx;if(z.x<z.y)z.xy=z.yx;z*=2.0;z.x-=1.0;
	z.xy*=rmx1;
	if(z.x+z.z<0.0)z.xz=-z.zx;if(z.x<z.z)z.xz=z.zx;if(z.x<z.y)z.xy=z.yx;z*=2.0;z.x-=1.0;
	z.xy*=rmx2;
	if(z.x+z.z<0.0)z.xz=-z.zx;if(z.x<z.z)z.xz=z.zx;if(z.x<z.y)z.xy=z.yx;z*=2.0;z.x-=1.0;
	if(bColoring)trap=z;
	if(typ<1.0){
		float dT=length(z-vec3(1.0,0.0,0.0))-0.12;
		dS=min(dT,max(abs(z.x)-1.0,max(abs(z.y)-0.05,abs(z.z)-0.05)));
		if(bColoring && dS==dT){trap=vec3(0.7,0.05,0.1);spec=0.25;specExp=8.0;}
	}else if(typ<2.0){
		dS=max(abs(z.x),max(abs(z.y),abs(z.z)))-0.525;
	}else{
		dS=max(length(z.yz)-0.9,abs(z.x)-0.075+step(0.2,min(1.0-length(z.yz),max(abs(z.y)-0.4,abs(z.z))))*0.01);
		//dS=max(abs(z.x)-0.75,max(abs(z.y)-0.5,abs(z.z)-0.01));
	}
	return dS*0.0625;
}
vec4 scene(vec3 ro, vec3 rd){
	vec3 posLight=ro+vec3(0.0,1.0,0.0);
	vec4 color=vec4(0.0,0.0,0.0,1.0);
	float fSteps=0.0;
	float t=0.0,d=10.0;
	for(int i=0;i<steps;i++){
		if(d<HitDistance*t)break;
		t+=d=DE(ro+rd*t);
		fSteps+=1.0;
	}
	ro+=rd*t;
	if(d<HitDistance*t){//we hit the fractal
		float cheapAO=1.0-fSteps/float(steps);
		bColoring=true;DE(ro);bColoring=false;
		vec2 ve=vec2(HitDistance,0.0);
		vec3 normal=normalize(vec3(-DE(ro-ve.xyy)+DE(ro+ve.xyy),-DE(ro-ve.yxy)+DE(ro+ve.yxy),-DE(ro-ve.yyx)+DE(ro+ve.yyx)));
		vec3 lightDir=normalize(posLight-ro);
		if(typ<1.0){
			if(spec>0.3)trap=2.0*texture2D(iChannel0,trap.yz*vec2(1.0,10.0)).rgb;
		}else if(typ<2.0){
			vec3 z=abs(trap);
			float d1=length(z.xy),d2=length(z.yz),d3=length(z.xz);
			float d=min(d1,min(d2,d3));
			float d4=max(z.x,max(z.y,z.z));
			if(d4==z.y){d=length(z.xz-vec2(0.25));}
			else if(d4==z.z){d=min(d,length(z.xy-vec2(0.25)));}
			d=clamp(pow(d+0.85,32.0),0.0,0.75);
			spec=d;
			trap=vec3(d);
		}else{
			if(abs(trap.x)<0.07)normal=normalize(normal+texture2D(iChannel0,trap.yz).rgb*0.5);
			trap=vec3(0.9,0.7,0.4);
		}
 		vec3 diffuse=(dot(normal,lightDir)*0.5+0.75)*trap;
		diffuse+=spec*pow(clamp(dot(lightDir,reflect(rd,normal)),0.0,1.0),specExp); 
		color.rgb=diffuse*cheapAO;
	}
	return clamp(color,0.0,1.0);
}

float wtf(float a){
	a=fract(a);
	float b=0.0625;
	for(int i=0;i<16;i++){
		if(a>b){
			if(a<b*2.0)a=b*2.0;
			a-=b;
			b*=2.0;
		}
	}
	return a*2.0;
}
mat3 lookat(vec3 fw,vec3 up){
	fw=normalize(fw);vec3 rt=normalize(cross(fw,normalize(up)));return mat3(rt,cross(rt,fw),fw);
}
void main() {
	float tim=time*0.1,r=0.75+sin(tim*2.3)*0.25;
	float a1=wtf(-tim*0.33333),a2=wtf(tim);
	rmx1=RMat2(a1*TAO);rmx2=RMat2(a2*TAO);
	vec3 ro = vec3(cos(tim)*r,0.275,sin(tim)*r);
	vec2 uv=(2.0*gl_FragCoord.xy-size.xy)/size.y;
	vec3 rd = lookat(-ro,vec3(0.0,1.0,0.0))*normalize(vec3(uv,1.0));
	typ=mod(2.0+time/30.0,3.0);
	gl_FragColor=scene(ro,rd);
}
